/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.youkai;

import dev.xkmc.fastprojectileapi.collision.EntityStorageHelper;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.GrazeCapability;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class YoukaiTargetContainer {
    private final YoukaiEntity youkai;
    private final int maxSize;
    @SerialClass.SerialField
    private final LinkedHashSet<UUID> list = new LinkedHashSet();

    public YoukaiTargetContainer(YoukaiEntity youkai, int maxSize) {
        this.youkai = youkai;
        this.maxSize = maxSize;
    }

    public void tick(@Nullable LivingEntity vanillaTarget) {
        if (this.youkai.m_9236_().m_5776_()) {
            return;
        }
        LivingEntity le = this.youkai.m_21188_();
        if (le != null && this.isValid(le) && !this.list.contains(le.m_20148_())) {
            this.list.add(le.m_20148_());
        } else {
            le = vanillaTarget;
            if (le != null) {
                if (this.isValid(le)) {
                    this.list.add(le.m_20148_());
                } else {
                    this.youkai.m_6710_(null);
                }
            }
        }
        this.list.removeIf(e -> !this.isValid((UUID)e));
        if (this.list.size() > this.maxSize) {
            ArrayList<UUID> tmp = new ArrayList<UUID>(this.list);
            this.list.clear();
            this.list.addAll(tmp.subList(tmp.size() - this.maxSize, tmp.size()));
        }
    }

    public void add(LivingEntity le) {
        if (this.isValid(le)) {
            this.list.add(le.m_20148_());
        }
    }

    public void remove(UUID id) {
        this.list.remove(id);
    }

    private boolean isValid(LivingEntity le) {
        return le.m_6084_() && le != this.youkai && le.m_142066_() && le.isAddedToWorld() && le.m_9236_() == this.youkai.m_9236_() && !this.youkai.shouldIgnore(le) && EntityStorageHelper.isPresent((Entity)le) && this.youkai.m_6779_(le);
    }

    private boolean isValid(UUID id) {
        Entity e = ((ServerLevel)this.youkai.m_9236_()).m_8791_(id);
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            return this.isValid(le);
        }
        return false;
    }

    public boolean contains(LivingEntity e) {
        return this.youkai.m_5448_() == e || this.list.contains(e.m_20148_());
    }

    public void checkTarget() {
        LivingEntity le;
        ArrayList<UUID> tmp;
        UUID id;
        Entity e;
        Level level = this.youkai.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        LivingEntity last = this.youkai.m_21188_();
        if ((last == null || !this.isValid(last)) && !this.list.isEmpty() && (e = sl.m_8791_(id = (tmp = new ArrayList<UUID>(this.list)).get(tmp.size() - 1))) instanceof LivingEntity && this.isValid(le = (LivingEntity)e)) {
            this.youkai.m_6703_(le);
        }
    }

    public List<LivingEntity> getTargets() {
        ArrayList<LivingEntity> ans = new ArrayList<LivingEntity>();
        Level level = this.youkai.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return ans;
        }
        ServerLevel sl = (ServerLevel)level;
        for (UUID id : this.list) {
            LivingEntity le;
            Entity e = sl.m_8791_(id);
            if (!(e instanceof LivingEntity) || !this.isValid(le = (LivingEntity)e)) continue;
            ans.add(le);
        }
        return ans;
    }

    @Nullable
    public LivingEntity getTarget() {
        List<LivingEntity> targets = this.getTargets();
        if (targets.isEmpty()) {
            return null;
        }
        for (LivingEntity e : targets) {
            Player player;
            GrazeCapability cap;
            if (!(e instanceof Player) || (cap = (GrazeCapability)GrazeCapability.HOLDER.get(player = (Player)e)).isInSession(this.youkai.m_20148_()) && cap.isInvul()) continue;
            return player;
        }
        return targets.get(0);
    }
}

